/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.fw.connmgr;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.connmgr.Authenticator;
import com.ibm.hwmca.fw.connmgr.ConnectionConstants;
import com.ibm.hwmca.fw.connmgr.ConnectionHandlerThread;
import com.ibm.hwmca.fw.connmgr.ConnectionManager;
import com.ibm.hwmca.fw.connmgr.ContextId;
import com.ibm.hwmca.fw.connmgr.HMCAuthenticator;
import com.ibm.hwmca.fw.connmgr.HMCServerSocketFactory;
import com.ibm.hwmca.fw.task.UserContext;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;

public class ConnectionServer
extends Thread
implements ConnectionConstants,
Authenticator.ContextKeeper {
    public static final String THIS_CLASS = "ConnectionServer";
    private boolean _stop = false;
    private ServerSocket _serverSocket;
    private int _port;
    private String _name;
    private Authenticator.GateKeeper _gateKeeper;
    private SecureRandom _randomizer = HMCAuthenticator.getRandomGenerator();
    private Map _contextMap = new HashMap();

    public ConnectionServer(String name, int port, Authenticator.GateKeeper gateKeeper) throws IOException, SocketException, HException {
        super(name);
        this._name = name + " on port " + port;
        this._port = port;
        this._gateKeeper = gateKeeper;
        this._serverSocket = HMCServerSocketFactory.getFactory().createServerSocket(port);
    }

    public int getPort() {
        return this._port;
    }

    public boolean isUserServer() {
        return this.getPort() == 9940;
    }

    public boolean isFCSServer() {
        return this.getPort() == 9920;
    }

    public InetAddress getInetAddress() {
        return this._serverSocket.getInetAddress();
    }

    Authenticator.ContextKeeper getContextKeeper() {
        return this;
    }

    Authenticator.GateKeeper getGateKeeper() {
        return this._gateKeeper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UserContext getContext(ContextId contextId) {
        UserContext result = null;
        Map map = this._contextMap;
        synchronized (map) {
            result = (UserContext)this._contextMap.get(contextId);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContextId putContext(UserContext context) throws HException {
        if (context == null) {
            throw new IllegalArgumentException("UserContext argument is null.");
        }
        ContextId id = context.getContextId();
        Map map = this._contextMap;
        synchronized (map) {
            if (id == null) {
                id = this.getNextContextId();
                context.setContextId(id);
            }
            this._contextMap.put(id, context);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ContextId getNextContextId() throws HException {
        ContextId result = null;
        Map map = this._contextMap;
        synchronized (map) {
            byte[] bytes = new byte[16];
            do {
                this._randomizer.nextBytes(bytes);
            } while (this._contextMap.containsKey(result = new ContextId(bytes)));
        }
        return result;
    }

    public void run() {
        Trace.trace("HSSLCONF", "--> ConnectionServer.run starting " + this);
        while (!this._stop) {
            try {
                Socket clientSocket = this._serverSocket.accept();
                Trace.trace("HSSLCOND", "ConnectionServer.run:  " + this + " accepted connection from " + clientSocket);
                new ConnectionHandlerThread(clientSocket, this).start();
                Trace.trace("HSSLCONF", "ConnectionServer.run:  " + this + " returned from connection handler thread for socket " + clientSocket);
            }
            catch (Throwable e) {
                Trace.trace("HSSLCOND", "ConnectionServer.run:  " + this + " caught an exception, logging, and continuing to accept connections ", e);
                ConnectionManager.logException(e, (short)2097);
            }
        }
        Trace.trace("HSSLCONF", "<-- ConnectionServer.run ending " + this);
    }

    public void stopRunning() throws IOException {
        Trace.trace("HSSLCONF", "--> ConnectionServer.stopRunning");
        if (this.isRunning()) {
            this._stop = true;
            this._serverSocket.close();
            this._serverSocket = null;
        }
        Trace.trace("HSSLCONF", "<-- ConnectionServer.stopRunning");
    }

    public boolean isRunning() {
        return this._serverSocket != null;
    }

    public String toString() {
        return this._name;
    }
}

